// WhatsApp Chat Widget
(function() {
    // Configuration - Replace with your WhatsApp number (include country code, no + or spaces)
    const WHATSAPP_NUMBER = '+233557065874'; // Example: '919876543210' for +91 9876543210
    const DEFAULT_MESSAGE = 'Hello! I need help with Twitter Video Downloader';
    
    // Create WhatsApp button
    const whatsappBtn = document.createElement('a');
    whatsappBtn.href = `https://wa.me/${WHATSAPP_NUMBER}?text=${encodeURIComponent(DEFAULT_MESSAGE)}`;
    whatsappBtn.target = '_blank';
    whatsappBtn.rel = 'noopener noreferrer';
    whatsappBtn.className = 'whatsapp-float';
    whatsappBtn.innerHTML = `
        <svg width="32" height="32" viewBox="0 0 32 32" fill="none" xmlns="http://www.w3.org/2000/svg">
            <path d="M16 0C7.164 0 0 7.164 0 16c0 2.824.736 5.488 2.028 7.788L0 32l8.428-2.016A15.92 15.92 0 0016 32c8.836 0 16-7.164 16-16S24.836 0 16 0zm0 29.336c-2.548 0-4.94-.72-6.98-1.956l-.5-.3-5.176 1.24 1.252-5.068-.324-.52A13.252 13.252 0 012.664 16C2.664 8.632 8.632 2.664 16 2.664S29.336 8.632 29.336 16 23.368 29.336 16 29.336z" fill="white"/>
            <path d="M23.548 19.628c-.396-.2-2.34-1.156-2.704-1.288-.364-.132-.628-.2-.892.2-.264.396-1.024 1.288-1.256 1.552-.232.264-.464.3-.86.1-.396-.2-1.672-.616-3.184-1.964-1.176-1.048-1.968-2.344-2.2-2.74-.232-.396-.024-.612.176-.808.18-.18.396-.464.596-.696.2-.232.264-.396.396-.66.132-.264.068-.496-.032-.696-.1-.2-.892-2.152-1.224-2.944-.324-.772-.652-.668-.892-.68-.232-.012-.496-.016-.76-.016-.264 0-.696.1-1.06.496-.364.396-1.388 1.356-1.388 3.308s1.42 3.836 1.62 4.1c.2.264 2.824 4.312 6.844 6.048.956.412 1.704.66 2.284.844.96.304 1.836.26 2.528.156.772-.116 2.34-.956 2.668-1.88.328-.924.328-1.716.228-1.88-.1-.164-.364-.264-.76-.464z" fill="white"/>
        </svg>
    `;
    
    // Add tooltip
    const tooltip = document.createElement('span');
    tooltip.className = 'whatsapp-tooltip';
    tooltip.textContent = 'Chat with us on WhatsApp';
    whatsappBtn.appendChild(tooltip);
    
    // Add to page when DOM is ready
    if (document.readyState === 'loading') {
        document.addEventListener('DOMContentLoaded', () => {
            document.body.appendChild(whatsappBtn);
        });
    } else {
        document.body.appendChild(whatsappBtn);
    }
})();
