# Twitter Video Downloader Web App 🐦

A beautiful web-based Twitter/X video downloader built with Flask and modern JavaScript. Download videos from Twitter/X with just a URL!

![Made with Python](http://ForTheBadge.com/images/badges/made-with-python.svg)

---

## Features ✨

- 🎨 Modern, responsive UI with gradient design
- ⚡ Fast video extraction and download
- 📱 Mobile-friendly interface
- 🎬 Downloads highest quality available
- 💫 Smooth animations and user feedback
- 🔒 Privacy-focused (no data stored)

## Screenshots

The app features:
- Clean, gradient purple interface
- Simple URL input field
- One-click download functionality
- Real-time feedback and loading states
- Responsive design for all devices

## Prerequisites

- Python 3.7 or higher
- pip (Python package manager)

## Installation

1. Clone or download this repository:
   ```bash
   git clone https://github.com/z1nc0r3/twitter-video-downloader
   cd twitter-video-downloader
   ```

2. Install required packages:
   ```bash
   pip install -r requirements.txt
   ```

## Usage

### Running the Web Application

1. Start the Flask server:
   ```bash
   python app.py
   ```

2. Open your web browser and navigate to:
   ```
   http://localhost:5000
   ```

3. To use the downloader:
   - Paste a Twitter/X video URL into the input field
   - Click "Get Video" to fetch video information
   - Click "Download Video" to save the video to your device

### Using the Command-Line Script

The original command-line script is still available:

```bash
python twitter_downloader.py {video_url}
```

Example:
```bash
python twitter_downloader.py https://x.com/realmadriden/status/1743790569866821949
```

## Project Structure

```
twitter-video-downloader/
│
├── app.py                      # Flask web application
├── twitter_downloader.py       # Original CLI script
├── requirements.txt            # Python dependencies
├── README.md                   # This file
│
├── templates/
│   └── index.html             # Main web page
│
├── static/
│   ├── css/
│   │   └── style.css          # Stylesheet
│   └── js/
│       └── script.js          # Frontend JavaScript
│
└── tests/
    ├── test_host.py
    └── test_url_verification.py
```

## API Endpoints

The Flask app provides the following API endpoints:

### GET `/`
Renders the main web interface.

### POST `/api/get-video-info`
Fetches video information from a Twitter URL.

**Request body:**
```json
{
  "url": "https://twitter.com/user/status/123..."
}
```

**Response:**
```json
{
  "video_url": "https://...",
  "title": "Video title",
  "filename": "video.mp4"
}
```

### POST `/api/download`
Downloads the video file.

**Request body:**
```json
{
  "video_url": "https://...",
  "filename": "video.mp4"
}
```

**Response:** Binary video file

## Configuration

By default, the app runs on:
- Host: `0.0.0.0` (accessible from network)
- Port: `5000`
- Debug mode: `True` (disable in production)

To change these settings, modify the last line in `app.py`:

```python
app.run(debug=False, host='127.0.0.1', port=8080)
```

## Important Notes

- This tool uses the [twitsave.com](https://twitsave.com) API to retrieve video URLs
- Ensure you have a stable internet connection
- Please respect copyright and Twitter's terms of service
- This project is not affiliated with twitsave.com or Twitter/X
- Review [twitsave.com/terms](https://twitsave.com/terms) before use

## Troubleshooting

### Port already in use
If port 5000 is already in use, change the port in `app.py`:
```python
app.run(debug=True, host='0.0.0.0', port=8080)
```

### Video not found
- Make sure the tweet contains a video
- Check that the URL is correct and accessible
- Some tweets may have restricted access

### Download fails
- Check your internet connection
- Verify the video URL is still valid
- Try a different browser if using the web interface

## Development

To contribute or modify:

1. Make changes to the code
2. Test thoroughly with different Twitter URLs
3. Ensure both web and CLI interfaces work
4. Update documentation as needed

## Technologies Used

- **Backend:** Flask (Python)
- **Frontend:** HTML5, CSS3, Vanilla JavaScript
- **Libraries:** requests, BeautifulSoup4, tqdm
- **API:** twitsave.com

## License

This project is open-source and available for educational purposes.

## Support

<a href="https://www.buymeacoffee.com/z1nc0r3" target="_blank">
  <img src="https://cdn.buymeacoffee.com/buttons/v2/default-yellow.png" alt="Buy Me A Coffee" style="height: 60px !important;width: 217px !important;" >
</a>

## Disclaimer

This tool is for educational purposes only. Users are responsible for ensuring they have the right to download and use any content. Always respect copyright laws and platform terms of service.

---

Made with ❤️ using Python and Flask
