# Quick Start Guide - Twitter Video Downloader Web App

## Installation Steps

1. **Install Python Dependencies**
   
   Open PowerShell in the project directory and run:
   ```powershell
   python -m pip install requests beautifulsoup4 tqdm Flask
   ```
   
   Or use the requirements file:
   ```powershell
   python -m pip install -r requirements.txt
   ```

2. **Start the Web Server**
   
   ```powershell
   python app.py
   ```
   
   You should see output like:
   ```
   * Running on http://0.0.0.0:5000
   * Running on http://127.0.0.1:5000
   ```

3. **Access the Website**
   
   Open your web browser and go to:
   ```
   http://localhost:5000
   ```

## Usage

1. Copy a Twitter/X video URL (e.g., `https://x.com/username/status/1234567890`)
2. Paste it into the input field
3. Click "Get Video"
4. Click "Download Video" to save the video

## Files Created

- `app.py` - Flask backend server
- `templates/index.html` - Main web page
- `static/css/style.css` - Styling
- `static/js/script.js` - Frontend functionality
- `requirements.txt` - Updated with Flask
- `README_WEB.md` - Full documentation

## Troubleshooting

**If you get "pip not found":**
- Use `python -m pip` instead of just `pip`

**If port 5000 is already in use:**
- Edit `app.py` and change the port number in the last line
- Or stop the process using port 5000

**If the website doesn't load:**
- Make sure Flask is installed
- Check that app.py is running without errors
- Try accessing `http://127.0.0.1:5000` instead

## Features

✅ Beautiful gradient UI
✅ Responsive design (mobile-friendly)
✅ Real-time feedback
✅ Error handling
✅ Progress indicators
✅ Automatic filename generation
✅ One-click downloads

Enjoy your new Twitter Video Downloader website! 🎉
